/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.world.noise;

import java.util.Random;

public class PerlinNoiseGenerator {
    private final int[] permutation;
    private final double frequency;
    private final double amplitude;
    private final int octaves;
    private final double persistence;

    public PerlinNoiseGenerator(long seed, double frequency, double amplitude, int octaves, double persistence) {
        this.frequency = frequency;
        this.amplitude = amplitude;
        this.octaves = octaves;
        this.persistence = persistence;
        this.permutation = new int[512];
        int[] p = new int[256];
        Random rand = new Random(seed);
        int i2 = 0;
        while (i2 < 256) {
            p[i2] = i2;
            ++i2;
        }
        i2 = 255;
        while (i2 > 0) {
            int j = rand.nextInt(i2 + 1);
            int temp = p[i2];
            p[i2] = p[j];
            p[j] = temp;
            --i2;
        }
        i2 = 0;
        while (i2 < 512) {
            this.permutation[i2] = p[i2 % 256];
            ++i2;
        }
    }

    public PerlinNoiseGenerator(long seed) {
        this(seed, 1.0, 1.0, 1, 0.5);
    }

    public PerlinNoiseGenerator(Random random) {
        this(random.nextLong(), 1.0, 1.0, 1, 0.5);
    }

    public double generateNoise(double x, double y, double z) {
        return this.noise3D(x, y, z);
    }

    public double noise2D(double x, double y) {
        double total = 0.0;
        double freq = this.frequency;
        double amp = this.amplitude;
        int i2 = 0;
        while (i2 < this.octaves) {
            total += this.rawNoise2D(x * freq, y * freq) * amp;
            freq *= 2.0;
            amp *= this.persistence;
            ++i2;
        }
        return total / this.amplitude;
    }

    public double noise3D(double x, double y, double z) {
        double total = 0.0;
        double freq = this.frequency;
        double amp = this.amplitude;
        int i2 = 0;
        while (i2 < this.octaves) {
            total += this.rawNoise3D(x * freq, y * freq, z * freq) * amp;
            freq *= 2.0;
            amp *= this.persistence;
            ++i2;
        }
        return total / this.amplitude;
    }

    private double rawNoise2D(double x, double y) {
        int X = (int)Math.floor(x) & 0xFF;
        int Y = (int)Math.floor(y) & 0xFF;
        x -= Math.floor(x);
        y -= Math.floor(y);
        double u = this.fade(x);
        double v = this.fade(y);
        int aa = this.permutation[X + this.permutation[Y]];
        int ab = this.permutation[X + this.permutation[Y + 1]];
        int ba = this.permutation[X + 1 + this.permutation[Y]];
        int bb = this.permutation[X + 1 + this.permutation[Y + 1]];
        double x1 = this.lerp(this.grad(aa, x, y), this.grad(ba, x - 1.0, y), u);
        double x2 = this.lerp(this.grad(ab, x, y - 1.0), this.grad(bb, x - 1.0, y - 1.0), u);
        return this.lerp(x1, x2, v);
    }

    private double rawNoise3D(double x, double y, double z) {
        int X = (int)Math.floor(x) & 0xFF;
        int Y = (int)Math.floor(y) & 0xFF;
        int Z = (int)Math.floor(z) & 0xFF;
        x -= Math.floor(x);
        y -= Math.floor(y);
        z -= Math.floor(z);
        double u = this.fade(x);
        double v = this.fade(y);
        double w = this.fade(z);
        int aaa = this.permutation[X + this.permutation[Y + this.permutation[Z]]];
        int aba = this.permutation[X + this.permutation[Y + 1 + this.permutation[Z]]];
        int aab = this.permutation[X + this.permutation[Y + this.permutation[Z + 1]]];
        int abb = this.permutation[X + this.permutation[Y + 1 + this.permutation[Z + 1]]];
        int baa = this.permutation[X + 1 + this.permutation[Y + this.permutation[Z]]];
        int bba = this.permutation[X + 1 + this.permutation[Y + 1 + this.permutation[Z]]];
        int bab = this.permutation[X + 1 + this.permutation[Y + this.permutation[Z + 1]]];
        int bbb = this.permutation[X + 1 + this.permutation[Y + 1 + this.permutation[Z + 1]]];
        double x1 = this.lerp(this.grad(aaa, x, y, z), this.grad(baa, x - 1.0, y, z), u);
        double x2 = this.lerp(this.grad(aba, x, y - 1.0, z), this.grad(bba, x - 1.0, y - 1.0, z), u);
        double y1 = this.lerp(x1, x2, v);
        x1 = this.lerp(this.grad(aab, x, y, z - 1.0), this.grad(bab, x - 1.0, y, z - 1.0), u);
        x2 = this.lerp(this.grad(abb, x, y - 1.0, z - 1.0), this.grad(bbb, x - 1.0, y - 1.0, z - 1.0), u);
        double y2 = this.lerp(x1, x2, v);
        return this.lerp(y1, y2, w);
    }

    private double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    private double lerp(double a2, double b2, double t) {
        return a2 + t * (b2 - a2);
    }

    private double grad(int hash, double x, double y) {
        double u;
        int h2 = hash & 0xF;
        double d2 = u = h2 < 8 ? x : y;
        double v = h2 < 4 ? y : (h2 == 12 || h2 == 14 ? x : 0.0);
        return ((h2 & 1) == 0 ? u : -u) + ((h2 & 2) == 0 ? v : -v);
    }

    private double grad(int hash, double x, double y, double z) {
        double u;
        int h2 = hash & 0xF;
        double d2 = u = h2 < 8 ? x : y;
        double v = h2 < 4 ? y : (h2 == 12 || h2 == 14 ? x : z);
        return ((h2 & 1) == 0 ? u : -u) + ((h2 & 2) == 0 ? v : -v);
    }
}

